/**
* \file: GstreamerVideoSink.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include "GstreamerVideoSink.h"
#include "GstreamerVideoSinkImpl.h"

namespace adit { namespace aauto {

GstreamerVideoSink::GstreamerVideoSink(uint8_t inSessionId, MessageRouter* inMessageRouter,
        bool inAutoStart) : AditVideoSink(inSessionId, inMessageRouter, inAutoStart)
{
    impl = new GstreamerVideoSinkImpl(this, (void*)inMessageRouter);
}

GstreamerVideoSink::~GstreamerVideoSink()
{
    /* This impl pointer is deleted at shared_ptr in callbak impl on GalReceiver */
//    delete impl;
}

bool GstreamerVideoSink::init()
{
    return impl->init();
}
void GstreamerVideoSink::shutdown()
{
    impl->shutdown();
}
void GstreamerVideoSink::setConfigItem(string inKey, string inValue)
{
    return impl->setConfigItem(inKey, inValue);
}

void GstreamerVideoSink::registerCallbacks(IAditVideoSinkCallbacks* inCallbacks)
{
    return impl->registerCallbacks(inCallbacks);
}

} } /* namespace adit { namespace aauto { */
